/*
 * Copyright European Commission's
 * Taxation and Customs Union Directorate-General (DG TAXUD).
 */
package eu.europa.ec.taxud.cesop.utils;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class IbanLength {
    private static final Map<String, Integer> code2value = Collections.unmodifiableMap(loadFromProperties());

    private static Map<String, Integer> loadFromProperties() {
        Properties properties = new Properties();
        try {
            properties.load(IbanLength.class.getResourceAsStream("/iban.properties"));
        } catch (IOException e) {
            throw new IllegalStateException("Failed to load iban.properties file which is supposed to be in classpath", e);
        }

        Map<String, Integer> result = new HashMap<>();
        String prefix = "iban.length.";
        properties.forEach((k, v) -> {
            if (!((String) k).startsWith(prefix)) {
                return;
            }

            String country = ((String) k).substring(prefix.length());
            result.put(country, Integer.parseInt((String) v));
        });
        return result;
    }

    public static Integer findForCountry(String code) {
        return code2value.get(code);
    }
}
